using System;
using System.Data;
using System.Collections;
using System.Text.RegularExpressions;
using System.Text;
using gov.va.med.vbecs.DAL;
using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.ExceptionManagement;
using Method = System.Reflection.MethodBase;
//
namespace gov.va.med.vbecs.BOL
{
    #region Header
		///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
		///<Warning> 
		///WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified
		///</Warning>
		///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<Note>
		///The Food and Drug Administration classifies this software as a medical device.  
		///As such, it may not be changed in any way. Modifications to this software may result 
		///in an adulterated medical device under 21CFR820, the use of which is considered to 
		///be a violation of US Federal Statutes.  Acquiring and implementing this software through 
		///the Freedom of information Act requires the implementor to assume total responsibility 
		///for the software, and become a registered manufacturer of a medical device, subject 
		///to FDA regulations
		///</Note>
		///<summary>
		///TestingMethod reference object.
		///</summary>
    #endregion

    #region TestingMethod

    public class TestingMethod
    {
        DataTable _testingMethodDataTable;
        DataRow _testingMethodDataRow;
        
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="8036"> 
		///		<ExpectedInput>Valid testing method code</ExpectedInput>
		///		<ExpectedOutput>Testing method object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="8037"> 
		///		<ExpectedInput>Invalid testing method code</ExpectedInput>
		///		<ExpectedOutput>Data access layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// Create an instance of TestingMethod based on its "TestingMethodCode".
        /// </summary>
        public TestingMethod(string testingMethodCode)
        {
            GetTestingMethodData(testingMethodCode);
        }

		/// <summary>
		/// LoadFromDataRow
		/// </summary>
		/// <param name="dataRow">Data row</param>
        protected void LoadFromDataRow(DataRow dataRow)
        {
            _testingMethodDataTable = dataRow.Table;
            _testingMethodDataRow = dataRow;
        }


        private void GetTestingMethodData(string  testingMethodCode)
        {
            LoadFromDataRow(DAL.ReferenceData.GetTestingMethod(testingMethodCode));
        }
        //
		#region Public Properties
        
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7813"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>testing method code</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7814"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the testing method code
        /// </summary>
        public string TestingMethodCode
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.TestingMethodCode))
                {
                    return "";
                }
                return (string)_testingMethodDataRow[Common.VbecsTables.TestingMethod.TestingMethodCode];
            }
        }
        
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7815"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>testing method text</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7816"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the testing method text
        /// </summary>
        public string TestingMethodText
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.TestingMethodText))
                {
                    return "";
                }
                return (string)_testingMethodDataRow[Common.VbecsTables.TestingMethod.TestingMethodText];
            }
        }
        
		///<Developers>
		///	<Developer>John Vrooland</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7817"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>sort column</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7818"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// short value containing the sort column
        /// </summary>
        public short SortColumn
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.SortColumn))
                {
                    return 0;
                }
                return (short)_testingMethodDataRow[Common.VbecsTables.TestingMethod.SortColumn];
            }
        }
        	
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7819"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>last update date</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7820"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// DateTime value containing the last update date
        /// </summary>
        public DateTime LastUpdateDate
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.LastUpdateDate))
                {
                    return System.DateTime.MinValue;
                }
                return (DateTime)_testingMethodDataRow[Common.VbecsTables.TestingMethod.LastUpdateDate];
            }
        }
        	
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7821"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>last update user</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7822"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// string value containing the last update user
        /// </summary>
        public string LastUpdateUser
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.LastUpdateUser))
                {
                    return "";
                }
                return (string)_testingMethodDataRow[Common.VbecsTables.TestingMethod.LastUpdateUser];
            }
        }
        		
        ///<Developers>
        ///	<Developer>John Vrooland</Developer>
        ///</Developers>
        ///<SiteName>Hines OIFO</SiteName>
        ///<CreationDate>6/13/2003</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7823"> 
		///		<ExpectedInput>Valid testing method object</ExpectedInput>
		///		<ExpectedOutput>row version</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7824"> 
		///		<ExpectedInput>N/A</ExpectedInput>
		///		<ExpectedOutput>N/A</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
        /// <summary>
        /// byte array value containing the row version
        /// </summary>
        public byte[] RowVersion
        {
			
            get 
            {
                if (_testingMethodDataRow.IsNull(Common.VbecsTables.TestingMethod.RowVersion))
                {
                    return null;
                }
                return (byte[])_testingMethodDataRow[Common.VbecsTables.TestingMethod.RowVersion];
            }
        }
				
        //
		#endregion
		
		///<Developers>
		///	<Developer></Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>8/15/2005</CreationDate>
		///<TestCases>
		///	
		///<Case type="0" testid ="7825"> 
		///		<ExpectedInput>Valid testing method code</ExpectedInput>
		///		<ExpectedOutput>testing method object</ExpectedOutput>
		///	</Case>
		///
		///<Case type="1" testid ="7826"> 
		///		<ExpectedInput>Invalid testing method code</ExpectedInput>
		///		<ExpectedOutput>Data access layer exception thrown</ExpectedOutput>
		///	</Case>
		///
		///</TestCases>
		///<Update></Update>
		///<ArchivePlan></ArchivePlan>
		///<Interfaces></Interfaces>
		///
		/// <summary>
		/// Returns a TestingMethod from testingMethodCode
		/// </summary>
		/// <param name="testingMethodCode"></param>
		/// <returns></returns>
        public static TestingMethod GetTestingMethod(string testingMethodCode)
        {
            return new TestingMethod(testingMethodCode);
        }
    }

	#endregion
}
